﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="FunctionalMobilityAssessment.aspx.cs"
    Inherits="TBI_Instruments_FunctionalMobilityAssessment" Title=""%>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register TagPrefix="VA" TagName="TechDeviceSelector" Src="~/controls/TechDeviceSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .style1
        {
            width: 900px;
            border-style: solid;
            border-width: 2px;
        }
        .style2
        {
            width: 900px;
        }
        
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    
    <script type="text/javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

        var tmr = null;

        function getTimerReference() {
            if (tmr == null) {
                tmr = $find("<%= InactiveTimer.ClientID %>");
            }
            return tmr;
        }

        function StopTimer() {
            // alert('stop');
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            //alert('start');
            getTimerReference()._startTimer();
        }

        function startRequest(sender, e) {
            StartTimer();
            //disable buttons during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
        }

        function endRequest(sender, e) {
            //re-enable buttons once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
        }
    </script>

    
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            $(document).ready(function () {
                //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
                //also resets inactive timer
                $('input').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
                //also resets inactive timer
                $('div').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a radio element
                $('input[type=radio]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a checkbox element
                $('input[type=checkbox]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                window.onbeforeunload = function (e) {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                }
            }); // END $(document).ready(function()

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }
                return ret;
            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;
                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Functional Mobility Assessment (FMA)"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="FMA" />
                <asp:Panel ID="PanelSurveyHeader" Width="99%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="true">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                        <strong>DIRECTIONS:</strong>
                        <br />
                        <p>
                            Step 1. Please answer the following 10 questions by placing an ‘X’ in the box under the response (completely agree, mostly
                            agree, slightly agree, etc.) that best matches your ability to function while in your current means of mobility (i.e., walking,
                            cane, crutch, walker, manual wheelchair, power wheelchair or scooter). All examples may not apply to you, and there may
                            be tasks you perform that are not listed. Mark each question only one time. If you answer, *slightly, *mostly, or *completely
                            disagree for any question, please write and specify the reason for your disagreement in the Comments section. Needs to be
                            validation rule. If answers are disagree in any measure, patient MUST answer comments.</p>
                        <p>
                            Step 2. Please determine your priorities, by rating the importance of the content in each of the 10 questions in the shaded
                            box to the right of each question. Rate your highest priority as 10, and your lowest priority as 1.</p>
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                <asp:Panel ID="PanelQuestions" Width="99%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table class="style2">
                        <tr>
                            <td colspan="100%">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="5">
                                </asp:Label> &nbsp;
                                
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="6">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="7" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                                    <br />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Question 1: What is your current means of mobility device? -->
                                <!-- Get text in code-behind -->
                                <!-- Tech Device Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TechDeviceSelector ID="ctrlTechDev" runat="server" QuestionNumber="1" StartTabIndex="17" />
                                <br />
                            </td>
                        </tr>
                    </table>
                    <br />
                    <table class="style1">
                        <tr>
                            <td style="width: 20px;">
                                1
                            </td>
                            <td style="width: 45%;">
                                <!-- Question 2: My current means of mobility allows me to carry out my daily routine as independently, safely and efficiently as possible: (e.g., tasks I want to do, need to do, am required to do- when and where needed) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="25">
                                </asp:Label>
                            </td>
                            <td style="width: 10px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 2 Choice List-->
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ2" TabIndex="26"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 2 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="27" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 2 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 2 : Question Number-->
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority1" runat="server" AssociatedControlID="ddlPriority1" SkinID="DataLabel" Text="Rating Priority:" TabIndex="28">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority1" runat="server" TabIndex="29">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority1" runat="server" ControlToValidate="ddlPriority1" TabIndex="30" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 2Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2Comment" runat="server" AssociatedControlID="txtCommentsQ2" SkinID="DataLabel" TabIndex="31">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ2" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="32"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                2
                            </td>
                            <td>
                                <!-- Question 3: My current means of mobility meets my comfort needs:(e.g., heat/moisture, sitting tolerance, pain, stability) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="33">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 3 Choice List-->
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ3" TabIndex="34"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 3 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="35" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 3 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 3 : Question Number-->
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority2" runat="server" AssociatedControlID="ddlPriority2" SkinID="DataLabel" Text="Rating Priority:" TabIndex="36">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority2" runat="server" TabIndex="37">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority2" runat="server" ControlToValidate="ddlPriority2" TabIndex="38" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 3Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3Comment" runat="server" AssociatedControlID="txtCommentsQ3" SkinID="DataLabel" TabIndex="39">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ3" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="40"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                3
                            </td>
                            <td>
                                <!-- Question 4: My current means of mobility meets my health needs:(e.g., pressure sores, breathing, edema control, medical equipment) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="41">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 4 Choice List-->
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ4" TabIndex="42"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 4 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="43" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 4 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 4 : Question Number-->
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority3" runat="server" AssociatedControlID="ddlPriority3" SkinID="DataLabel" Text="Rating Priority:" TabIndex="44">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority3" runat="server" TabIndex="45">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority3" runat="server" ControlToValidate="ddlPriority3" TabIndex="46" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 4Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4Comment" runat="server" AssociatedControlID="txtCommentsQ4" SkinID="DataLabel" TabIndex="47">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ4" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="48"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                4
                            </td>
                            <td>
                                <!-- Question 5: My current means of mobility allows me to be as independent, safe and efficient as possible: (e.g., do what I want it to
                                do when and where I want to do it) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="49">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 5 Choice List-->
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ5" TabIndex="50"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 5 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="51" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 5 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 5 : Question Number-->
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority4" runat="server" AssociatedControlID="ddlPriority4" SkinID="DataLabel" Text="Rating Priority:" TabIndex="52">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority4" runat="server" TabIndex="53">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority4" runat="server" ControlToValidate="ddlPriority4" TabIndex="54" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 5Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5Comment" runat="server" AssociatedControlID="txtCommentsQ5" SkinID="DataLabel" TabIndex="55">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ5" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="56"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                5
                            </td>
                            <td>
                                <!-- Question 6: My current means of mobility allows me to reach and carry out tasks at different surface heights as independently, safely
                                and efficiently as possible: (e.g., table, counters, floors, shelves) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="57">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 6 Choice List-->
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ6" TabIndex="58"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 6 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="59" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 6 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 6 : Question Number-->
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority5" runat="server" AssociatedControlID="ddlPriority5" SkinID="DataLabel" Text="Rating Priority:" TabIndex="60">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority5" runat="server" TabIndex="61">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority5" runat="server" ControlToValidate="ddlPriority5" TabIndex="62" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 6Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6Comment" runat="server" AssociatedControlID="txtCommentsQ6" SkinID="DataLabel" TabIndex="63">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ6" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="64"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                6
                            </td>
                            <td>
                                <!-- Question 7: My current means of mobility allows me to transfer from one surface to another: (e.g., bed, toilet, chair) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="65">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 7 Choice List-->
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ7" TabIndex="66"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 7 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7" TabIndex="67" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 7 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 7 : Question Number-->
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority6" runat="server" AssociatedControlID="ddlPriority6" SkinID="DataLabel" Text="Rating Priority:" TabIndex="68">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority6" runat="server" TabIndex="69">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority6" runat="server" ControlToValidate="ddlPriority6" TabIndex="70" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 7Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7Comment" runat="server" AssociatedControlID="txtCommentsQ7" SkinID="DataLabel" TabIndex="71">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ7" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="72"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                7
                            </td>
                            <td>
                                <!-- Question 8: My current means of mobility allows me to carry out personal care tasks: (e.g., dressing, bowel/bladder care, eating, hygiene) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="73">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 8 Choice List-->
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ8" TabIndex="74"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 8 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="75" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 8 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 8 : Question Number-->
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority7" runat="server" AssociatedControlID="ddlPriority7" SkinID="DataLabel" Text="Rating Priority:" TabIndex="76">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority7" runat="server" TabIndex="77">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority7" runat="server" ControlToValidate="ddlPriority7" TabIndex="78" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 8Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8Comment" runat="server" AssociatedControlID="txtCommentsQ8" SkinID="DataLabel" TabIndex="79">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ8" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="80"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                8
                            </td>
                            <td>
                                <!-- Question 9: My current means of mobility allows me to get around indoors: (e.g., home, work, mall, restaurants, ramps, obstacles) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="81">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 9 Choice List-->
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ9" TabIndex="82"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 9 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="83" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 9 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 9 : Question Number-->
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority8" runat="server" AssociatedControlID="ddlPriority8" SkinID="DataLabel" Text="Rating Priority:" TabIndex="84">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority8" runat="server" TabIndex="85">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority8" runat="server" ControlToValidate="ddlPriority8" TabIndex="86" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 9Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9Comment" runat="server" AssociatedControlID="txtCommentsQ9" SkinID="DataLabel" TabIndex="87">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ9" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="88"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                9
                            </td>
                            <td>
                                <!-- Question 10: My current means of mobility allows me to get around outdoors: (e.g., uneven surfaces, dirt, grass, gravel, ramps, obstacles) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="89">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 10 Choice List-->
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ10" TabIndex="90"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 10 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="91" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 10 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 10 : Question Number-->
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority9" runat="server" AssociatedControlID="ddlPriority9" SkinID="DataLabel" Text="Rating Priority:" TabIndex="92">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority9" runat="server" TabIndex="93">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority9" runat="server" ControlToValidate="ddlPriority9" TabIndex="94" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 10Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10Comment" runat="server" AssociatedControlID="txtCommentsQ10" SkinID="DataLabel" TabIndex="95">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ10" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="96"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                10
                            </td>
                            <td>
                                <!-- Question 11: My current means of mobility allows me to use personal or public transportation as independently, safely and efficiently
                                as possible: (e.g., secure, stow, ride) -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="97">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Question 11 Choice List-->
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ11" TabIndex="98"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                </asp:RadioButtonList>
                                <!--Question 11 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="99" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 11 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 11 : Question Number-->
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                            <td style="text-align:right; padding-right:23px;">
                                <asp:Label ID="LabelPriority10" runat="server" AssociatedControlID="ddlPriority10" SkinID="DataLabel" Text="Rating Priority:" TabIndex="100">
                                </asp:Label>
                                <br />
                                <i>(Highest priority as 10,<br />lowest priority as 1)</i><br />
                                <asp:DropDownList ID="ddlPriority10" runat="server" TabIndex="101">
                                    <asp:ListItem Value="" Text="--Select Rating Priority--"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="1"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="2"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="3"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="4"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="5"></asp:ListItem>
                                    <asp:ListItem Value="6" Text="6"></asp:ListItem>
                                    <asp:ListItem Value="7" Text="7"></asp:ListItem>
                                    <asp:ListItem Value="8" Text="8"></asp:ListItem>
                                    <asp:ListItem Value="9" Text="9"></asp:ListItem>
                                    <asp:ListItem Value="10" Text="10"></asp:ListItem>
                                </asp:DropDownList>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPriority10" runat="server" ControlToValidate="ddlPriority10" TabIndex="102" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="4">
                                <!-- Question 11Comment: Comments: -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11Comment" runat="server" AssociatedControlID="txtCommentsQ11" SkinID="DataLabel" TabIndex="103">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtCommentsQ11" runat="server" MaxLength="1000" TextMode="MultiLine" Rows="4" Width="97%" TabIndex="104"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="5">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="105" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="106" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="107" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
